  OPTION BASE 0 'needed for I2CPort
  OPTION EXPLICIT
  OPTION AUTORUN ON
  OPTION BREAK 0  'prevent console causing halt  
  CONST STARTTIME=3000   'init timeout
  'COLOURS
  CONST C.FOREGROUND = RGB(white)
  CONST C.BACKGROUND = RGB(BLACK)
  Const C.TEXT = RGB(192,192,192)   'default grey is a bit dark
  CONST C.ERROR = RGB(RED)
  CONST C.BUTTON = RGB(BLUE)
  CONST C.FREQ = RGB(WHITE)
  CONST C.WARNING = RGB(YELLOW)
  CONST C.BUTTONHIGHLIGHT = RGB(CYAN)
  CONST C.BUTTONFADE = RGB(64,64,64)
  'hardware config Rev D/Rev E
  CONST PIN.I2CSDA = 18   'used by IC2 via I2C
  CONST PIN.I2CSCL = 17   'used by IC2 via I2C
  CONST PIN.PLLRUN = 24   'pulled low by 10k (Pin 24 in Rev D)
  CONST PIN.IC1CS = 5     'DAC1
  CONST PIN.IC1LDAC = 4
  CONST PIN.IC8CS = 26    'DAC2, LDAC on DAC2 pulled high as no need for precision
  CONST PIN.IC7 = 16      'DS18B20
  CONST PIN.GPS1PPS = 21  '1PPS signal from GPS
  CONST PIN.MM1PPS = 22   'Micromite's 1PPS output
  'GPS on COM2, IC1 and IC8 on SPI
  'defines for DACs (combines registers and pins)
  CONST DAC1A=PIN.IC1CS + &H7000
  CONST DAC1B=PIN.IC1CS + &HF000
  CONST DAC2A=PIN.IC8CS + &H7000
  CONST DAC2B=PIN.IC8CS + &HF000
  'defines for PLL Multipliers (corresponds to registers, m,n also have bits spread out at +1 and +2)
  CONST PLL1M=1
  CONST PLL2M=4
  CONST PLL3M=7
  CONST PLL1N=2
  CONST PLL2N=5
  CONST PLL3N=8
  CONST PLL1P=13'P0
  CONST PLL2P=18'P5
  CONST PLL3P=17'P4
  CONST PLL4P=16'P3
  'status flags
  DIM INTEGER STATUS.TEMP%=0,STATUS.GPS%=0,STATUS.IC2%=0                'functional checking, default to not ready
  DIM INTEGER STATUS.40MHZIN%=0,STATUS.GPS1PPS%=0,STATUS.GPSLOCKED%=0   'functional checking, default to not ready
  DIM STATUS.OVERALL%=0     '1=PLL only, 2=disciplined, 3=temp comped
  DIM IC2CONFIGWRITE%(25)=(17,1,4,0,1,4,0,1,4,32,128,33,20,4,4,4,4,4,4,56,57,58,59,60,61,9)'custom mod2 CON3=PLL1=P0,Y0 CON2=PLL2=P5,Y5 40Mhz=PLL3=P4,Y4, CON4=PLL3=P3,Y3, low VCO
  'DIM IC2CONFIGWRITE%(25)=(17,1,4,0,1,4,224,1,4,32,128,33,20,4,4,4,4,4,4,56,57,58,59,60,61,9)'custom mod2 CON3=PLL1=P0,Y0 CON2=PLL2=P5,Y5 40Mhz=PLL3=P4,Y4, CON4=PLL3=P3,Y3, high VCO
  DIM IC2CONFIGREAD%(25)'for read
  
  ' globals used by Sub DrawButton
  Dim Integer key_coord(22, 5)
  Dim String key_caption(22)
  '"statics" for CHECKPPS/CHECK40MHZ
  DIM INTEGER CHECKPPSLASTTIME%=0,CHECKPPSLASTSTATE%=0
  DIM INTEGER CHECK40MHZLASTTIME%=0,CHECK40MHZLASTSTATE%=0
  DIM INTEGER ISR1PPSLASTCOUNT%=0,ISR1PPSLASTPERIOD%,ISR1PPSLASTTIMER%=0
  DIM INTEGER PLLACCUMULATOR%=0,PLLCOUNT%=0,PLLAVE%=0         'count clocks/pps pulses/average count
  DIM INTEGER PPSCOUNT%=0
  'other globals
  DIM TEMP%
  DIM GPSSENTENCE$="",GPSFIELDS$(20),GPSFIELDPTR%=0    'current GPS sentence being parsed
  DIM GPSTIME$,GPSLAT$,GPSLON$,GPSDATE$,GPSFIX$        'from GPRMC sentence
  DIM INTEGER PRESETS%(5,5,4) 'connectors 2,3,4, 4 presets each, 4 values per preset
  DIM INTEGER FSET%(5,4)      'current values- 2,3,4 connectors, 4 values for each
  DIM INTEGER CLIPBOARD%(4)   'for copying between settings
  DIM FLOAT TEMPSETPOINT=35.0
  DIM INTEGER TEMPCV%=0,TEMPGAIN%=1000,TEMPOFFSET%=3000        'default to off for failsafe
  DIM INTEGER VCOCONTROL%=10066329 'start at midpoint of pulling range
  DIM INTEGER VCOPULLGAIN%=33554   '35k is 100% at minimum pull
  DIM INTEGER VCOADJUSTDELAY%=1000
  DIM FFRESULT%(3) AS INTEGER 'for result of find frequency
  DIM INTEGER F.VCO%=40000000 'notional frequency reference
  DIM NFIXED%,MFIXED%,PLLFIXED%         'PLL used for 40MHz ref has N,M locked
  NFIXED%=4           'fixed for PLL
  MFIXED%=1
  PLLFIXED%=(F.VCO%*NFIXED%)\MFIXED%
  
  SETPRESETS
  VAR RESTORE
  DO_INIT_SCREEN
  DO_INIT_PROCESS
  DRAWMAIN
  
MAINSCREEN:       'main menu screen and main program loop
  TEMP%=CheckButtonPress(1,5)
  IF TEMP%=1 THEN CheckButtonRelease TEMP%: DO_SETTINGS: DRAWMAIN
  IF TEMP%=2 THEN CheckButtonRelease TEMP%: DO_CON(2): DRAWMAIN
  IF TEMP%=3 THEN CheckButtonRelease TEMP%: DO_CON(3): DRAWMAIN
  IF TEMP%=4 THEN CheckButtonRelease TEMP%: DO_CON(4): DRAWMAIN
  IF TEMP%=5 THEN CheckButtonRelease TEMP%: DO_STATUS: DRAWMAIN
  DOBACKGROUND
  GOTO MAINSCREEN:
  
SUB DOBACKGROUND 'all the processes that occur out of sight
  'IF ISR1PPSLASTTIMER%-TIMER<
  LOCAL T%
  T%=TIMER
  IF STATUS.IC2% = 0 THEN STATUS.IC2% = INITIC2()                 'check PLL
  IF STATUS.TEMP% = 0 THEN IF GETTEMP()<200 THEN STATUS.TEMP%=1   'check temp sensor
  TEMP%=GPSFEED()                                                 'sets STATUS.GPS% and STATUS.GPSLOCKED% internally
  IF STATUS.GPS1PPS%=0 then STATUS.GPS1PPS%=CHECKPPS()            'check for pulses
  IF STATUS.40MHZIN%=0 THEN STATUS.40MHZIN%=CHECK40MHZ()          'check VCO output
  IF (STATUS.IC2%<>0) AND (STATUS.40MHZIN%<>0) THEN               'UPDATE device status
    STATUS.OVERALL%=1
    IF (STATUS.GPS%<>0) AND (STATUS.GPS1PPS%<>0) AND (STATUS.GPSLOCKED%<>0) THEN
      STATUS.OVERALL%=2
      IF (STATUS.TEMP%<>0) THEN STATUS.OVERALL%=3
    END IF
  END iF
  TEMPCV%=(TEMPSETPOINT-GETTEMP())*TEMPGAIN%+TEMPOFFSET%      'temp gives 1000 on fail, so will failsafe to 0% output
  IF TEMPCV%<0 THEN TEMPCV%=0
  IF TEMPCV%>4095 THEN TEMPCV%=4095
  SETDAC(DAC2B,TEMPCV%)
  IF PLLCOUNT%>0 THEN PLLAVE%=PLLACCUMULATOR%/PLLCOUNT%
  IF PLLCOUNT%>VCOADJUSTDELAY% THEN DO_PLL_ADJUST
END SUB
  
SUB DO_PLL_ADJUST
  LOCAL N1%,N2%,C1%,C2% 'samples, pulse count
  LOCAL OFFSET%
  'PLL adjustment- VC is from 2.5V regulated supply
  'pulling range 0.5V => -5ppm, 2.5V => +5ppm (minimum)
  'at 40MHz, 5ppm is 200Hz
  'DAC has 2^24 ~ 16million steps over 2.5V=>13M steps over the pulling range
  '1Hz discrepancy => 33554 steps adjustment, with 1000 samples, we can measure mHz
  'pulling direction not specified
RETRY:
  N1%=PLLCOUNT%
  C1%=PLLACCUMULATOR%
  N2%=PLLCOUNT%
  C2%=PLLACCUMULATOR%
  IF N1%<>N2% THEN GOTO RETRY:    'interrupt has changed value
  IF C1%<>C2% THEN GOTO RETRY:    'while we're trying to read it
  OFFSET%=C1%-F.VCO%*N1%          'error over all samples
  VCOCONTROL%=VCOCONTROL%-((OFFSET%*VCOPULLGAIN%)\N1%)
  IF VCOCONTROL%<0 THEN VCOCONTROL%=0
  IF VCOCONTROL%>16777215 then VCOCONTROL%= 16777215
RESETRETRY:
  PLLCOUNT%=0
  PLLACCUMULATOR%=0
  IF PLLCOUNT% <>0 OR PLLACCUMULATOR%<>0 THEN GOTO RESETRETRY:    'make sure they're both zeroed together
  SETVCODAC(VCOCONTROL%)      'VCO pulling voltage
END SUB
  
SUB SQUISHNUMBER(X%,Y%,NUM%,S%)   'x,y pos, number, scale (1 and 2 will fit on screen)
  LOCAL TEMP$
  LOCAL INTEGER C.TEMP,N%
  N%=NUM%
  C.TEMP=C.FREQ
  IF N%>99999999 THEN N%=99999999: C.TEMP=C.ERROR
  IF N%<0 THEN N%=0: C.TEMP=C.ERROR
  TEMP$=RIGHT$("         "+STR$(N%),8)
  TEXT X%,Y%,MID$(TEMP$,1,1),LT,2,S%,C.TEMP,C.BACKGROUND
  TEXT X%+14*S%,Y%,MID$(TEMP$,2,1),LT,2,S%,C.TEMP,C.BACKGROUND
  TEXT X%+33*S%,Y%,MID$(TEMP$,3,1),LT,2,S%,C.TEMP,C.BACKGROUND
  TEXT X%+47*S%,Y%,MID$(TEMP$,4,1),LT,2,S%,C.TEMP,C.BACKGROUND
  TEXT X%+61*S%,Y%,MID$(TEMP$,5,1),LT,2,S%,C.TEMP,C.BACKGROUND
  TEXT X%+80*S%,Y%,MID$(TEMP$,6,1),LT,2,S%,C.TEMP,C.BACKGROUND
  TEXT X%+94*S%,Y%,MID$(TEMP$,7,1),LT,2,S%,C.TEMP,C.BACKGROUND
  TEXT X%+108*S%,Y%,MID$(TEMP$,8,1)+"Hz",LT,2,S%,C.TEMP,C.BACKGROUND
END SUB
  
SUB DRAWMAIN
  'set up start page
  CLS C.BACKGROUND
  TEXT 160,96,"Silicon Chip",CM,2,1,C.TEXT,C.BACKGROUND
  TEXT 160,120,"GPS Frequency",CM,2,1,C.TEXT,C.BACKGROUND
  TEXT 160,144,"Reference",CM,2,1,C.TEXT,C.BACKGROUND
  DrawButton 1,0,10,5,140,35,C.BUTTON,"SETTINGS"
  DrawButton 3,0,10,195,140,35,C.BUTTON,"CON3"
  DrawButton 4,0,170,5,140,35,C.BUTTON,"CON4"
  DrawButton 2,0,170,195,140,35,C.BUTTON,"CON2"
  DrawButton 5,0,10,45,140,35,C.BUTTON,"STATUS"
  SQUISHNUMBER(166,166,FSET%(2,0),1)
  SQUISHNUMBER(1,166,FSET%(3,0),1)
  SQUISHNUMBER(166,50,FSET%(4,0),1)
END SUB
  
SUB DO_STATUS
  CLS C.BACKGROUND
  DrawButton 1,0,210,205,100,35,C.BUTTON,"BACK"
DO_STATUS_LOOP:
  TEXT 1,0,"STATUS:"+FUNCSTRING(STATUS.OVERALL%),LT,2,1,C.TEXT,C.BACKGROUND
  'TEXT 10,24,"APPROX FREQ:  "+left$(STR$(CHECK40MHZ()/1000,0,3)+"MHz            ",14),LT,1,1,C.TEXT,C.BACKGROUND
  'TEXT 10,24,"APPROX FREQ:  "+left$(STR$(ISR1PPSLASTPERIOD%/1000000.0,0,3)+"MHz "+STR$(PPSCOUNT%)+"            ",18),LT,1,1,C.TEXT,C.BACKGROUND
  TEXT 10,24,"APPROX FREQ:  "+left$(STR$(PLLAVE%)+"Hz("+STR$(PLLCOUNT%)+")            ",18),LT,1,1,C.TEXT,C.BACKGROUND
  TEXT 10,40,"GPS TIME:     "+left$(GPSTIME$+"               ",14),LT,1,1,C.TEXT,C.BACKGROUND
  TEXT 10,56,"GPS DATE:     "+left$(GPSDATE$+"               ",14),LT,1,1,C.TEXT,C.BACKGROUND
  TEXT 10,72,"GPS LAT:      "+left$(GPSLAT$+"               ",14),LT,1,1,C.TEXT,C.BACKGROUND
  TEXT 10,88,"GPS LON:      "+left$(GPSLON$+"               ",14),LT,1,1,C.TEXT,C.BACKGROUND
  TEXT 10,104,"GPS FIX:      "+left$(GPSFIX$+"               ",14),LT,1,1,C.TEXT,C.BACKGROUND
  TEXT 10,120,"Temperature:  "+left$(STR$(GETTEMP(),0,1)+"`C/"+STR$(TEMPSETPOINT,0,1)+"`C("+str$(TEMPCV%)+")         ",19),LT,1,1,C.TEXT,C.BACKGROUND
  DO_STATS(10,136)
  DOBACKGROUND
  IF CheckButtonPress(1,1)<>1 THEN GOTO DO_STATUS_LOOP:
  CheckButtonRelease 1
END SUB
  
SUB DO_SETTINGS
  LOCAL TEMP%
  DRAW_SETTINGS
DO_SETTINGS_LOOP:
  TEMP%=CheckButtonPress(1,5)
  IF TEMP%<0 THEN GOTO DO_SETTINGS_LOOP:'wait for a press
  IF TEMP%=1 THEN 'save/store
    VAR SAVE PRESETS%(),FSET%()
    VAR SAVE TEMPSETPOINT,TEMPGAIN%,TEMPOFFSET%
    VAR SAVE VCOPULLGAIN%, VCOCONTROL%,VCOADJUSTDELAY%
    CheckButtonRelease TEMP%
    MessageBox "Settings","saved"
    DRAW_SETTINGS 'refresh
  END IF
  IF TEMP%=3 THEN CheckButtonRelease TEMP%: DO_PRESETS: DRAW_SETTINGS
  IF TEMP%=4 THEN CheckButtonRelease TEMP%: DO_TEMPERATURE: DRAW_SETTINGS
  IF TEMP%=5 THEN CheckButtonRelease TEMP%: DO_VCO_TRIM: DRAW_SETTINGS
  IF TEMP%<>2 THEN GOTO DO_SETTINGS_LOOP: 'exit on 2
  CheckButtonRelease TEMP%
END SUB
  
SUB DRAW_SETTINGS
  CLS C.BACKGROUND
  TEXT 1,1,"Settings:",LT,2,1,C.TEXT,C.BACKGROUND
  DrawButton 1,0,10,202,140,35,C.BUTTON,"SAVE ALL"
  DrawButton 2,0,170,202,140,35,C.BUTTON,"BACK"
  DrawButton 3,0,60,30,200,35,C.BUTTON,"PRESETS"
  DrawButton 4,0,60,70,200,35,C.BUTTON,"TEMPERATURE"
  DrawButton 5,0,60,110,200,35,C.BUTTON,"VCO TRIM"
END SUB
  
SUB DO_PRESETS
  LOCAL E%,C%,S%'entry being edited, connection, sub entry (CON2 Main,1,2,3,4 CON3 Main,1,2,3,4 CON4 Main,1,2,3,4)
  LOCAL F%,N%,M%,P% 'on-screen values
  LOCAL TEMP%
  LOCAL TAG$
  E%=0
  F%=FSET%(2,0)
  N%=FSET%(2,1)
  M%=FSET%(2,2)
  P%=FSET%(2,3)
DO_PRESETS_TOTAL_REDRAW:
  CLS C.BACKGROUND
  TEXT 1,1,"Presets:",LT,2,1,C.TEXT,C.BACKGROUND
  DrawButton 1,0,170,202,140,35,C.BUTTON,"BACK"
  DrawButton 2,0,10,30,140,35,C.BUTTON,"PREVIOUS"
  DrawButton 3,0,170,30,140,35,C.BUTTON,"NEXT"
  DrawButton 4,0,10,130,140,35,C.BUTTON,"COPY"
  DrawButton 5,0,170,130,140,35,C.BUTTON,"PASTE"
DO_PRESETS_LOOP_REDRAW:
  C%=E%\5
  S%=E%-(C%*5)  '0=main, 1 2 3 4
  C%=C%+2   '2,3,4
  IF S%>0 THEN
    TAG$=":P "+STR$(S%)+"  "
    F%=PRESETS%(C%,S%,0)
    N%=PRESETS%(C%,S%,1)
    M%=PRESETS%(C%,S%,2)
    P%=PRESETS%(C%,S%,3)
  ELSE
    TAG$=":OUT  "
    F%=FSET%(C%,0)
    N%=FSET%(C%,1)
    M%=FSET%(C%,2)
    P%=FSET%(C%,3)
  END IF
  TEXT 1,70,"CON"+STR$(C%)+TAG$,LT,2,1,C.TEXT,C.BACKGROUND
  SQUISHNUMBER(161,70,F%,1)
  TEXT 1,100,"N="+RIGHT$("    "+STR$(N%),4)+" M="+RIGHT$("   "+STR$(M%),3)+" P="+RIGHT$("   "+STR$(P%),3),LT,2,1,C.TEXT,C.BACKGROUND
  TEXT 1,170,"N="+RIGHT$("    "+STR$(CLIPBOARD%(1)),4)+" M="+RIGHT$("   "+STR$(CLIPBOARD%(2)),3)+" P="+RIGHT$("   "+STR$(CLIPBOARD%(3)),3),LT,2,1,C.TEXT,C.BACKGROUND
  SQUISHNUMBER(1,205,CLIPBOARD%(0),1)
DO_PRESETS_LOOP:
  TEMP%=CheckButtonPress(1,5)
  IF TEMP%=-1 THEN GOTO DO_PRESETS_LOOP:
  CheckButtonRelease TEMP%
  IF TEMP%=2 THEN E%=E%-1: iF E%<0 THEN E%=0
  IF TEMP%=3 THEN E%=E%+1: IF E%>14 THEN E%=14
  IF TEMP%=4 THEN
    CLIPBOARD%(0)=F%
    CLIPBOARD%(1)=N%
    CLIPBOARD%(2)=M%
    CLIPBOARD%(3)=P%
  END IF
  IF TEMP%=5 THEN
    IF C%=4 AND CLIPBOARD%(1)<>NFIXED% AND CLIPBOARD%(2)<> MFIXED% THEN MessageBox "Invalid","CON 4 value":GOTO DO_PRESETS_TOTAL_REDRAW:
    IF S%>0 THEN
      PRESETS%(C%,S%,0)=CLIPBOARD%(0)
      PRESETS%(C%,S%,1)=CLIPBOARD%(1)
      PRESETS%(C%,S%,2)=CLIPBOARD%(2)
      PRESETS%(C%,S%,3)=CLIPBOARD%(3)
    ELSE
      FSET%(C%,0)=CLIPBOARD%(0)
      FSET%(C%,1)=CLIPBOARD%(1)
      FSET%(C%,2)=CLIPBOARD%(2)
      FSET%(C%,3)=CLIPBOARD%(3)
      SET_CON_OUT(C%)
    END IF
  END IF
  IF TEMP% <> 1 THEN GOTO DO_PRESETS_LOOP_REDRAW:
END SUB
  
SUB DO_TEMPERATURE  'set TEMPSETPOINT, TEMPGAIN,TEMPOFFSET
  LOCAL L1%,L2%,L3%,TEMP%,TC%     'store before save
  L1%=INT(TEMPSETPOINT)
  L2%=TEMPGAIN%
  L3%=TEMPOFFSET%
DO_TEMP_REDRAW:
  CLS C.BACKGROUND
  TEXT 1,1,"Temperature:",LT,2,1,C.TEXT,C.BACKGROUND
  DrawButton 1,0,10,202,140,35,C.BUTTON,"SAVE"
  DrawButton 2,0,170,202,140,35,C.BUTTON,"BACK"
  DrawButton 3,0,10,30,140,35,C.BUTTON,"Setpoint"
  DrawButton 4,0,10,70,140,35,C.BUTTON,"Gain"
  DrawButton 5,0,10,110,140,35,C.BUTTON,"Offset"
  TC%=C.TEXT
  IF L1%<>INT(TEMPSETPOINT) THEN TC%=C.WARNING    'unsaved change
  TEXT 240,36,STR$(L1%)+"`C",CT,2,1,TC%,C.BACKGROUND
  TC%=C.TEXT
  IF L2%<>TEMPGAIN% THEN TC%=C.WARNING    'unsaved change
  TEXT 240,76,STR$(L2%),CT,2,1,TC%,C.BACKGROUND
  TC%=C.TEXT
  IF L3%<>TEMPOFFSET% THEN TC%=C.WARNING    'unsaved change
  TEXT 240,116,STR$(L3%),CT,2,1,TC%,C.BACKGROUND
DO_TEMPERATURE_LOOP:
  TEMP%=CheckButtonPress(1,5)
  IF TEMP%=1 THEN
    TEMPSETPOINT=L1%      'store temps
    TEMPGAIN%=L2%
    TEMPOFFSET%=L3%
    VAR SAVE TEMPSETPOINT,TEMPGAIN%,TEMPOFFSET% 'save
    MessageBox "Settings","saved"
    EXIT SUB
  END iF
  IF TEMP%=3 THEN CheckButtonRelease TEMP%: L1%=GET_NUMBER_PAGE(0,60,L1%,"Setpoint"): GOTO DO_TEMP_REDRAW:
  IF TEMP%=4 THEN CheckButtonRelease TEMP%: L2%=GET_NUMBER_PAGE(0,10000,L2%,"Gain"): GOTO DO_TEMP_REDRAW:
  IF TEMP%=5 THEN CheckButtonRelease TEMP%: L3%=GET_NUMBER_PAGE(0,4095,L3%,"Offset"): GOTO DO_TEMP_REDRAW:
  IF TEMP%<>2 THEN GOTO DO_TEMPERATURE_LOOP: 'exit on 2
END SUB
  
SUB DO_VCO_TRIM 'set VCOPULLGAIN, VCOCONTROL%
  LOCAL L1%,L2%,L3%,TEMP%,TC%     'store before save
  L1%=VCOPULLGAIN%
  L2%=VCOCONTROL%
  L3%=VCOADJUSTDELAY%
DO_VCO_REDRAW:
  CLS C.BACKGROUND
  TEXT 1,1,"VCO Settings:",LT,2,1,C.TEXT,C.BACKGROUND
  DrawButton 1,0,10,202,140,35,C.BUTTON,"SAVE"
  DrawButton 2,0,170,202,140,35,C.BUTTON,"BACK"
  DrawButton 3,0,10,30,140,35,C.BUTTON,"Gain"
  DrawButton 4,0,10,70,140,35,C.BUTTON,"C Value"
  DrawButton 5,0,10,110,140,35,C.BUTTON,"Update s"
  TC%=C.TEXT
  IF L1%<>VCOPULLGAIN% THEN TC%=C.WARNING    'unsaved change
  TEXT 240,36,STR$(L1%),CT,2,1,TC%,C.BACKGROUND
  TC%=C.TEXT
  IF L2%<>VCOCONTROL% THEN TC%=C.WARNING    'unsaved change
  TEXT 240,76,STR$(L2%),CT,2,1,TC%,C.BACKGROUND
  TC%=C.TEXT
  IF L3%<>VCOADJUSTDELAY% THEN TC%=C.WARNING    'unsaved change
  TEXT 240,116,STR$(L3%),CT,2,1,TC%,C.BACKGROUND
DO_VCO_LOOP:
  TEMP%=CheckButtonPress(1,5)
  IF TEMP%=1 THEN
    VCOPULLGAIN%=L1%      'store vco
    VCOCONTROL%=L2%
    VCOADJUSTDELAY%=L3%
    VAR SAVE VCOPULLGAIN%, VCOCONTROL%,VCOADJUSTDELAY%'save
    SETVCODAC(VCOCONTROL%)      'VCO pulling voltage
    MessageBox "Settings","saved"
    EXIT SUB
  END iF
  IF TEMP%=3 THEN CheckButtonRelease TEMP%: L1%=GET_NUMBER_PAGE(0,100000,L1%,"Gain"): GOTO DO_VCO_REDRAW:
  IF TEMP%=4 THEN CheckButtonRelease TEMP%: L2%=GET_NUMBER_PAGE(0,16777215,L2%,"C Value"): GOTO DO_VCO_REDRAW:
  IF TEMP%=5 THEN CheckButtonRelease TEMP%: L3%=GET_NUMBER_PAGE(0,86400,L3%,"Update (s)"): GOTO DO_VCO_REDRAW:
  IF TEMP%<>2 THEN GOTO DO_VCO_LOOP: 'exit on 2
END SUB
  
FUNCTION GET_NUMBER_PAGE(MIN% AS INTEGER, MAX% AS INTEGER,CV% AS INTEGER,TITLE$ AS STRING) AS INTEGER
  GET_NUMBER_PAGE=CV%     'return current value if no change
  LOCAL TEMP%,TC%
GET_NUMBER_PAGE_REDRAW:
  CLS C.BACKGROUND
  DrawButton 0,0,170,193,42,42,C.BUTTON,"0"
  DrawButton 1,0,170,58,42,42,C.BUTTON,"1"
  DrawButton 2,0,220,58,42,42,C.BUTTON,"2"
  DrawButton 3,0,270,58,42,42,C.BUTTON,"3"
  DrawButton 4,0,170,103,42,42,C.BUTTON,"4"
  DrawButton 5,0,220,103,42,42,C.BUTTON,"5"
  DrawButton 6,0,270,103,42,42,C.BUTTON,"6"
  DrawButton 7,0,170,148,42,42,C.BUTTON,"7"
  DrawButton 8,0,220,148,42,42,C.BUTTON,"8"
  DrawButton 9,0,270,148,42,42,C.BUTTON,"9"
  DrawButton 10,0,220,193,92,42,C.BUTTON,"<-"
  DrawButton 11,0,10,166,140,35,C.BUTTON,"OK"
  DrawButton 12,0,10,202,140,35,C.BUTTON,"CANCEL"
  TEXT 80,67,TITLE$,CT,2,1,C.TEXT,C.BACKGROUND
  TEXT 80,117,STR$(MIN%)+"-"+STR$(MAX%),CT,2,1,C.TEXT,C.BACKGROUND
GET_NUMBER_PAGE_LOOP:
  TC%=C.TEXT
  IF GET_NUMBER_PAGE < MIN% OR GET_NUMBER_PAGE >MAX% THEN TC%=C.WARNING
  TEXT 310,1,RIGHT$("        "+STR$(GET_NUMBER_PAGE),8),RT,2,2,TC%,C.BACKGROUND
  TEMP%=CheckButtonPress(0,12)
  IF TEMP%<0 THEN GOTO GET_NUMBER_PAGE_LOOP:
  CheckButtonRelease TEMP%
  IF (TEMP%>=0) AND (TEMP% <=9) THEN GET_NUMBER_PAGE=GET_NUMBER_PAGE*10+TEMP%: if GET_NUMBER_PAGE>99999999 THEN GET_NUMBER_PAGE=99999999
  IF TEMP%=10 THEN GET_NUMBER_PAGE=GET_NUMBER_PAGE\10
  IF TEMP%=11 THEN
    IF TC%<> C.TEXT THEN MessageBox "Out of range","not accepted": GOTO GET_NUMBER_PAGE_REDRAW:
    EXIT FUNCTION
  END IF
  IF TEMP%<>12 THEN GOTO GET_NUMBER_PAGE_LOOP:
  GET_NUMBER_PAGE=CV%   'cancel, don't change
END FUNCTION
  
SUB DO_CON(V%)
  LOCAL TEMP%
  DRAW_CON(V%)
DO_CON_LOOP:
  TEMP%=CheckButtonPress(1,7)
  IF TEMP%=1 THEN CheckButtonRelease TEMP%: DO_SEEKF(V%): DRAW_CON(V%):TEMP%=0
  IF TEMP%=2 THEN CheckButtonRelease TEMP%: DO_ADVF(V%): DRAW_CON(V%):TEMP%=0
  IF TEMP%=3 THEN CheckButtonRelease TEMP%: EXIT SUB
  IF TEMP%>=4 and TEMP% <=7 THEN PRESETBUTTON(V%,TEMP%-3,TEMP%): DRAW_CON(V%) :TEMP%=0
  DOBACKGROUND
  GOTO DO_CON_LOOP:
END SUB
  
SUB DRAW_CON(N%)
  CLS C.BACKGROUND
  TEXT 10,1,"CON"+STR$(N%),LT,2,2,C.TEXT,C.BACKGROUND
  SQUISHNUMBER(1,191,FSET%(N%,0),2)
  DrawButton 1,0,10,49,140,35,C.BUTTON,"SEEK F"
  DrawButton 2,0,10,96,140,35,C.BUTTON,"ADVANCED"
  DrawButton 3,0,10,143,140,35,C.BUTTON,"BACK"
  DrawButton 4,0,165,2,150,35,C.BUTTON,"1:"+LEFT$(str$(PRESETS%(N%,1,0)/1000000.0,0,2),4)+"MHz"
  DrawButton 5,0,165,49,150,35,C.BUTTON,"2:"+LEFT$(STR$(PRESETS%(N%,2,0)/1000000.0,0,2),4)+"MHz"
  DrawButton 6,0,165,96,150,35,C.BUTTON,"3:"+LEFT$(STR$(PRESETS%(N%,3,0)/1000000.0,0,2),4)+"MHz"
  DrawButton 7,0,165,143,150,35,C.BUTTON,"4:"+LEFT$(STR$(PRESETS%(N%,4,0)/1000000.0,0,2),4)+"MHz"
END SUB
  
SUB DO_SEEKF(W%)        'automatic frequency seek, needs special case for CON4
  LOCAL T%,FFR%,TEMP%,FPLL%,PLLCOLOUR%
  T%=ENTER_NUMBER()
  IF T%<0 THEN EXIT SUB   'cancelled
  IF T%<1000000 THEN MessageBox "Frequency","too low" : EXIT SUB
  IF W%=4 THEN DO_SEEK4(T%): EXIT SUB         'special case for CON4 (can only change P
  CLS C.BACKGROUND
  TEXT 10,1,"SEEKING:",LT,2,1,C.TEXT,C.BACKGROUND
  SQUISHNUMBER(1,25,T%,2)
  FFR%=CFindFrequency(FFRESULT%(),F.VCO%,T%)
  IF FFR%<100 THEN MessageBox "Seek","failed" : EXIT SUB
  TEXT 10,73,"FOUND:",LT,2,1,C.TEXT,C.BACKGROUND
  SQUISHNUMBER(1,97,FFR%,2)
  TEXT 10,145,"N="+RIGHT$("    "+STR$(FFRESULT%(0)),4)+" M="+RIGHT$("    "+STR$(FFRESULT%(1)),3)+" P="+RIGHT$("    "+STR$(FFRESULT%(2)),3),LT,2,1,C.TEXT,C.BACKGROUND
  FPLL%=(F.VCO%*FFRESULT%(0))\FFRESULT%(1)
  PLLCOLOUR%=C.TEXT
  IF FPLL%<80000000 THEN PLLCOLOUR%=C.WARNING
  IF FPLL%>300000000 THEN PLLCOLOUR%=C.WARNING
  TEXT 10,169,"Fpll="+STR$(FPLL%)+"Hz",LT,2,1,PLLCOLOUR%,C.BACKGROUND
  DrawButton 1,0,10,200,140,35,C.BUTTON,"OK"
  DrawButton 2,0,170,200,140,35,C.BUTTON,"CANCEL"
DO_SEEKF_LOOP:
  TEMP%=CheckButtonPress(1,2)
  IF TEMP%=1 THEN
    FSET%(W%,0)=FFR%          'F
    FSET%(W%,1)=FFRESULT%(0)  'N
    FSET%(W%,2)=FFRESULT%(1)  'M
    FSET%(W%,3)=FFRESULT%(2)  'P
    SET_CON_OUT(W%)
    CheckButtonRelease TEMP%
    EXIT SUB
  END IF
  IF TEMP%=2 THEN
    CheckButtonRelease TEMP%
    EXIT SUB
  END IF
  GOTO DO_SEEKF_LOOP:
END SUB
  
SUB DO_SEEK4(T%)    'find match for T% using P only
  LOCAL FPLL%,TEMP%,FFR%,TSEEK%
  FPLL%=PLLFIXED%
  CLS C.BACKGROUND
  TEXT 10,1,"SEEKING:",LT,2,1,C.TEXT,C.BACKGROUND
  SQUISHNUMBER(1,25,T%,2)
  TSEEK%=FPLL%\T%        'integer divide rounds down, need to try TSEEK%+1
  IF TSEEK%<1 THEN TSEEK%=1
  IF ABS((FPLL%\TSEEK%)-T%)>ABS((FPLL%\(TSEEK%+1))-T%) THEN TSEEK%=TSEEK%+1    '+1 is closer
  IF TSEEK%>127 THEN TSEEK%=127
  FFR%=FPLL%\TSEEK%
  TEXT 10,73,"FOUND:",LT,2,1,C.TEXT,C.BACKGROUND
  SQUISHNUMBER(1,97,FFR%,2)
  TEXT 10,145,"N="+RIGHT$("    "+STR$(NFIXED%),4)+" M="+RIGHT$("    "+STR$(MFIXED%),3)+" P="+RIGHT$("    "+STR$(TSEEK%),3),LT,2,1,C.TEXT,C.BACKGROUND
  TEXT 10,169,"Fpll="+STR$(FPLL%)+"Hz",LT,2,1,C.TEXT,C.BACKGROUND
  DrawButton 1,0,10,200,140,35,C.BUTTON,"OK"
  DrawButton 2,0,170,200,140,35,C.BUTTON,"CANCEL"
DO_SEEK4_LOOP:
  TEMP%=CheckButtonPress(1,2)
  IF TEMP%=1 THEN
    FSET%(4,0)=FFR%          'F
    FSET%(4,1)=NFIXED%       'N
    FSET%(4,2)=MFIXED%       'M
    FSET%(4,3)=TSEEK%        'P
    SET_CON_OUT(4)
    CheckButtonRelease TEMP%
    EXIT SUB
  END IF
  IF TEMP%=2 THEN
    CheckButtonRelease TEMP%
    EXIT SUB
  END IF
  GOTO DO_SEEK4_LOOP:
END SUB
  
SUB DO_ADVF(W%)         'advanced frequency set
  LOCAL INTEGER NSET%,MSET%,PSET%,PLLSETA%,F%,PLLCOL%,FIELD%,FIELDCOL%' FIELD% 1=N,2=M,3=P
  FIELD%=1
  DRAW_ADVF(W%)   'fixed parts, changing parts drawn in loop
  F%=FSET%(W%,0)
  NSET%=FSET%(W%,1)
  MSET%=FSET%(W%,2)
  PSET%=FSET%(W%,3)
DO_ADVF_LOOP:
  IF W%=4 THEN      'fix M/N for CON4
    NSET%=NFIXED%
    MSET%=MFIXED%
    FIELD%=3        'only P can be changed
  END IF
  PLLSETA%=(F.VCO%*NSET%)\MSET%
  F%=PLLSETA%\PSET%
  SQUISHNUMBER(1,1,F%,2)
  PLLCOL%=C.TEXT
  IF PLLSETA%<80000000 OR PLLSETA%>300000000 THEN PLLCOL%=C.WARNING
  TEXT 1,42,"Fpll="+RIGHT$("            "+STR$(PLLSETA%),9)+"Hz",LT,1,1,PLLCOL%,C.BACKGROUND
  FIELDCOL%=C.BUTTON
  IF FIELD%=1 THEN FIELDCOL%=C.BUTTONHIGHLIGHT
  IF W%=4 THEN FIELDCOL%=C.BUTTONFADE
  DrawButton 15,0,26,58,110,35,FIELDCOL%,"N="+STR$(NSET%)
  FIELDCOL%=C.BUTTON
  IF FIELD%=2 THEN FIELDCOL%=C.BUTTONHIGHLIGHT
  IF W%=4 THEN FIELDCOL%=C.BUTTONFADE
  DrawButton 18,0,26,94,110,35,FIELDCOL%,"M="+STR$(MSET%)
  FIELDCOL%=C.BUTTON
  IF FIELD%=3 THEN FIELDCOL%=C.BUTTONHIGHLIGHT
  DrawButton 21,0,26,130,110,35,FIELDCOL%,"P="+STR$(PSET%)
DO_ADVF_INNER_LOOP:
  TEMP%=CheckButtonPress(0,21)
  IF TEMP%<0 THEN GOTO DO_ADVF_INNER_LOOP:
  IF TEMP%=15 THEN FIELD%=1   'select N
  IF TEMP%=18 THEN FIELD%=2   'select M
  IF TEMP%=21 THEN FIELD%=3   'select P
  IF TEMP%=13 THEN NSET%=NSET%-1
  IF TEMP%=14 THEN NSET%=NSET%+1
  IF TEMP%=16 THEN MSET%=MSET%-1
  IF TEMP%=17 THEN MSET%=MSET%+1
  IF TEMP%=19 THEN PSET%=PSET%-1
  IF TEMP%=20 THEN PSET%=PSET%+1
  IF (TEMP%>=0) AND (TEMP% <=9) THEN  'numbers
    IF FIELD%=1 THEN NSET%=NSET%*10+TEMP%
    IF FIELD%=2 THEN MSET%=MSET%*10+TEMP%
    IF FIELD%=3 THEN PSET%=PSET%*10+TEMP%
  END IF
  IF TEMP%=10 THEN      'backspace
    IF FIELD%=1 THEN NSET%=NSET%\10
    IF FIELD%=2 THEN MSET%=MSET%\10
    IF FIELD%=3 THEN PSET%=PSET%\10
  END IF
  IF TEMP%=11 THEN      'ok, save values and exit
    PLLSETA%=(F.VCO%*NSET%)\MSET%  'recalculate F
    F%=PLLSETA%\PSET%
    FSET%(W%,0)=F%
    FSET%(W%,1)=NSET%
    FSET%(W%,2)=MSET%
    FSET%(W%,3)=PSET%
    SET_CON_OUT(W%)
    EXIT SUB
  END IF
  'group all check together as multiple things can change values above
  IF NSET%<1 THEN NSET%=1
  IF NSET%>4095 THEN NSET%=4095
  IF MSET%<1 THEN MSET%=1
  IF MSET%>511 THEN MSET%=511
  IF PSET%<1 THEN PSET%=1
  IF PSET%>127 THEN PSET%=127
  IF MSET%>NSET% THEN MSET%=NSET%   'hardware limitations
  CheckButtonRelease TEMP%          'wait for release before responding
  IF TEMP%<>12 THEN GOTO DO_ADVF_LOOP:
END SUB
  
SUB DRAW_ADVF(W%)       'draw page for advanced frequency set (buttons only)
  CLS C.BACKGROUND
  DrawButton 0,0,170,193,42,42,C.BUTTON,"0"
  DrawButton 1,0,170,58,42,42,C.BUTTON,"1"
  DrawButton 2,0,220,58,42,42,C.BUTTON,"2"
  DrawButton 3,0,270,58,42,42,C.BUTTON,"3"
  DrawButton 4,0,170,103,42,42,C.BUTTON,"4"
  DrawButton 5,0,220,103,42,42,C.BUTTON,"5"
  DrawButton 6,0,270,103,42,42,C.BUTTON,"6"
  DrawButton 7,0,170,148,42,42,C.BUTTON,"7"
  DrawButton 8,0,220,148,42,42,C.BUTTON,"8"
  DrawButton 9,0,270,148,42,42,C.BUTTON,"9"
  DrawButton 10,0,220,193,92,42,C.BUTTON,"<-"
  DrawButton 11,0,10,166,140,35,C.BUTTON,"OK"
  DrawButton 12,0,10,202,140,35,C.BUTTON,"CANCEL"
  DrawButton 13,0,1,58,20,35,C.BUTTON,"<"
  DrawButton 14,0,141,58,20,35,C.BUTTON,">"
  DrawButton 16,0,1,94,20,35,C.BUTTON,"<"
  DrawButton 17,0,141,94,20,35,C.BUTTON,">"
  DrawButton 19,0,1,130,20,35,C.BUTTON,"<"
  DrawButton 20,0,141,130,20,35,C.BUTTON,">"
END SUB
  
SUB LOADPRESET(W%,X%)   'load con W with preset x
  FSET%(W%,0)=PRESETS%(W%,X%,0)
  FSET%(W%,1)=PRESETS%(W%,X%,1)
  FSET%(W%,2)=PRESETS%(W%,X%,2)
  FSET%(W%,3)=PRESETS%(W%,X%,3)
END SUB
  
SUB SAVEPRESET(W%,X%)   'save current con W value into preset x
  PRESETS%(W%,X%,0)=FSET%(W%,0)
  PRESETS%(W%,X%,1)=FSET%(W%,1)
  PRESETS%(W%,X%,2)=FSET%(W%,2)
  PRESETS%(W%,X%,3)=FSET%(W%,3)
END SUB
  
SUB PRESETBUTTON(W%,X%,B%)  'check hold on button B%, and load if short press, save if long press
  LOCAL TM%
  TM%=TIMER
  CheckButtonRelease B%
  TM%=TIMER-TM%         'check delay
  IF TM%<1000 THEN      'short press to load
    LOADPRESET(W%,X%)
    SET_CON_OUT(W%)     'send to output
    EXIT SUB
  ELSE                  'long press to save
    SAVEPRESET(W%,X%)
  END IF
END SUB
  
SUB SETPRESETS    'load defaults
  LOCAL INTEGER A%,B%,C%
  FOR A%=0 TO 5
    C%=1
    FOR B%=1 TO 4
      C%=C%*2
      PRESETS%(A%,B%,0)=160000000/C%  '40MHz
      PRESETS%(A%,B%,1)=4         'N=4
      PRESETS%(A%,B%,2)=1         'M=1
      PRESETS%(A%,B%,3)=C%         'P=4
    NEXT B%
    FSET%(A%,0)=40000000  '40MHz
    FSET%(A%,1)=4         'N=4
    FSET%(A%,2)=1         'M=1
    FSET%(A%,3)=4         'P=4
  NEXT A%
  CLIPBOARD%(0)=40000000  '40MHz
  CLIPBOARD%(1)=4         'N=4
  CLIPBOARD%(2)=1         'M=1
  CLIPBOARD%(3)=4         'P=4
END SUB
  
FUNCTION ENTER_NUMBER()   'full screen keypad
  ENTER_NUMBER=-1         'flag for cancel
  LOCAL ENTRY%=0,TEMP%
  CLS C.BACKGROUND
  SQUISHNUMBER(1,1,ENTRY%,2)
  DrawButton 0,0,170,193,42,42,C.BUTTON,"0"
  DrawButton 1,0,170,58,42,42,C.BUTTON,"1"
  DrawButton 2,0,220,58,42,42,C.BUTTON,"2"
  DrawButton 3,0,270,58,42,42,C.BUTTON,"3"
  DrawButton 4,0,170,103,42,42,C.BUTTON,"4"
  DrawButton 5,0,220,103,42,42,C.BUTTON,"5"
  DrawButton 6,0,270,103,42,42,C.BUTTON,"6"
  DrawButton 7,0,170,148,42,42,C.BUTTON,"7"
  DrawButton 8,0,220,148,42,42,C.BUTTON,"8"
  DrawButton 9,0,270,148,42,42,C.BUTTON,"9"
  DrawButton 10,0,220,193,92,42,C.BUTTON,"<-"
  DrawButton 11,0,10,106,140,35,C.BUTTON,"kHz"
  DrawButton 12,0,10,153,140,35,C.BUTTON,"OK"
  DrawButton 13,0,10,200,140,35,C.BUTTON,"CANCEL"
  DrawButton 14,0,10,59,140,35,C.BUTTON,"MHz"
ENTER_NUMBER_LOOP:
  TEMP%=CheckButtonPress(0,14)
  IF (TEMP%>=0) AND (TEMP% <=9) THEN ENTRY%=ENTRY%*10+TEMP%:SQUISHNUMBER(1,1,ENTRY%,2):CheckButtonRelease TEMP%
  IF TEMP%=10 THEN ENTRY%=ENTRY%\10:SQUISHNUMBER(1,1,ENTRY%,2):CheckButtonRelease TEMP%
  IF TEMP%=11 THEN ENTRY%=ENTRY%*1000:SQUISHNUMBER(1,1,ENTRY%,2):CheckButtonRelease TEMP%
  IF TEMP%=14 THEN ENTRY%=ENTRY%*1000000:SQUISHNUMBER(1,1,ENTRY%,2):CheckButtonRelease TEMP%
  IF TEMP%=12 THEN CheckButtonRelease TEMP%:ENTER_NUMBER=ENTRY%:EXIT FUNCTION
  IF TEMP%=13 THEN CheckButtonRelease TEMP%:EXIT FUNCTION
  IF ENTRY%>99999999 THEN
    ENTRY%=ENTRY% MOD 100000000
    SQUISHNUMBER(1,1,ENTRY%,2)
  END iF
  GOTO ENTER_NUMBER_LOOP:
END FUNCTION
  
  'Button routines borrowed from the SUPERCLOCK
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Draw buttons and get button presses
  '
  ' The subrouting DrawButton will draw a button (normally used when drawing
  ' the screen for input).
  '
  ' The function CheckButtonPress() will check if a button has been touched.
  ' If it has it will set it to selected (reverse video) and return with the
  ' button's number.
  '
  ' The subroutine CheckButtonRelease will wait for the touch to be released
  ' and will then draw the button as normal.
  '
  ' These routines use the global arrays key_coord() and key_caption() to
  ' track the coordinates and size of each button and save its caption.
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  
  ' draw a button
Sub DrawButton n As Integer, mode As Integer, x As Integer, y As Integer, w As Integer, h As Integer, c As Integer, s As String
  Local Integer bc, fc
  
  If mode = 0 Then
    key_coord(n,0) = x : key_coord(n,1) = y : key_coord(n,2) = w : key_coord(n,3) = h
    key_coord(n,4) = c : key_caption(n) = s
  EndIf
  
  If mode > 1 Then
    bc = key_coord(n,4) : fc = C.BACKGROUND    ' draw in reverse video if it is being touched
  Else
    bc = C.BACKGROUND : fc = key_coord(n,4)    ' a normal (untouched) button
  EndIf
  
  RBox key_coord(n,0), key_coord(n,1), key_coord(n,2), key_coord(n,3), , key_coord(n,4), bc)
  Text key_coord(n,0) + key_coord(n,2)/2, key_coord(n,1) + key_coord(n,3)/2, key_caption(n), CM, 2, 1, fc, bc
End Sub
  
  
  ' check if a button has been touch and animate the button's image
  ' returns the button's number
Function CheckButtonPress(startn As Integer, endn As Integer) As Integer
  Local Integer xt, yellowt, n
  
  CheckButtonPress = -1
  If Touch(x) <> -1 Then
    ' we have a touch
    xt = Touch(x)
    yellowt = Touch(y)
    ' scan the array key_coord() to see if the touch was within the
    ' boundaries of a button
    For n = startn To endn
      If xt > key_coord(n,0) And xt < key_coord(n,0) + key_coord(n,2) And yellowt > key_coord(n,1) And yellowt < key_coord(n,1) + key_coord(n,3) Then
        ' we have a button press
        ' draw the button as pressed
        DrawButton n, 2
        CheckButtonPress = n
        Exit For
      EndIf
    Next n
  EndIf
End Function
  
  
  ' wait for the touch to be released and then draw the button as normal
Sub CheckButtonRelease n As Integer
  ' if a button is currently down check if it has been released
  Do While Touch(x) <> -1 : Loop   ' wait for the button to be released
  DrawButton n, 1                  ' draw the button as normal (ie, not pressed)
End Sub
  
  
  
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' this handy routine draws a message box with an OK button
  ' then waits for the button to be touched
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub MessageBox s1 As String, s2 As String
  Local Integer w
  If Len(s1) > Len(s2) Then w = Len(s1) Else w = Len(s2)
  w = w * 8     ' get the width of the text (used for the box width)
  if w < 40 THEN w=40' if narrower than OK button
  ' draw the box and the message in it
  RBox MM.HRes/2 - w - 20, 60, w * 2 + 40, 130, , C.TEXT, 0
  Text MM.HRes/2, 70, s1, CT, 1, 2, RGB(white)
  Text MM.HRes/2, 100, s2, CT, 1, 2, RGB(white)
  
  ' draw the OK button
  RBox 110, 140, 100, 34, , C.BUTTON
  Text MM.HRes/2, 157, "OK", CM, 1, 2, C.BUTTON
  
  ' wait for the button to be touched
  Do While Not (Touch(x) > 110 And Touch(x) < 210 And Touch(y) > 140 And Touch(y) < 180) : Loop
  
  ' draw the OK button as depressed
  RBox 110, 140, 100, 34, , C.BUTTON, C.BUTTON
  Text MM.HRes/2, 157, "OK", CM, 1, 2, 0, C.BUTTON
  
  ' wait for the touch to be removed
  Do While Touch(x) <> -1 : Loop
End Sub
  
  
  ' Arial_round_16x24.bas
  ' Font type    : Full (95 characters)
  ' Font size    : 16x24 pixels
  ' Memory usage : 4564 bytes
DefineFont #2
  5F201810 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 C0038001 C003C003 C003C003
  C003C003 8003C003 80018001 00008001 80010000 C003C003 00008001 00000000
  00000000 00000000 30063006 600C600C 700E700E 00003006 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 18031803 38073807
  FC3FFC3F 700E7006 600E700E FC3FFC3F E01CE01C C018C01C 0000C018 00000000
  00000000 80018001 F01FC007 B83DF81F 9839B839 801F803D F803F00F 9C31BC01
  9C399C39 F81FB83D 8001E007 80018001 00000000 10780000 20CC30F8 40CC60CC
  80CCC0CC 3C018079 66026603 660C6606 3C18660C 00003C10 00000000 00000000
  00000000 00000000 00000000 C00F8007 E01CE01C C00FE01C 081F0007 D8719C3B
  F070F871 DE3FFC78 00008C0F 00000000 00000000 C000E000 8001C001 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 C0004000 8001C001 80038003 00070007 00070007 00070007 00070007
  80038003 C0018001 4000C000 00000000 00000000 00030002 80018003 C001C001
  E000E000 E000E000 E000E000 E000E000 C001C001 80038001 00020003 00000000
  00000000 00000000 00000000 00000000 C0000000 C000C000 F807D806 E001C000
  10033003 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  80018001 80018001 F81FF81F 80018001 80018001 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 80030003 80018003 00038001 00000000 00000000 00000000 00000000
  00000000 00000000 F00FF00F 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 80038003 00008003 00000000 00000000 70003000 60007000 E000E000
  C000E000 C001C001 8001C001 80038003 00038003 00070007 00000006 00000000
  00000000 E0070000 F81FF00F 1C38381C 1C381C38 1C381C38 1C381C38 1C381C38
  381C1C38 F00FF81F 0000E007 00000000 00000000 60000000 E001E000 E007E003
  E01CE01F E000E018 E000E000 E000E000 E000E000 E000E000 0000E000 00000000
  00000000 E0070000 F81FF81F 1C383C3C 1C001C38 78003800 E003F000 000F8007
  003C001E FC3FF83F 0000FC3F 00000000 00000000 E0070000 F81FF00F 3838783C
  78003800 F001F001 3C00F800 1C381C30 783C3C38 F00FF81F 0000E007 00000000
  00000000 60000000 F000F000 F003F001 70077003 700C700E 7038701C FC3F7038
  7000FC3F 70007000 00007000 00000000 00000000 FC1F0000 F81FFC1F 001C001C
  E01F001C F81FF01F 1C003C1C 1C001C00 383C1C38 F01FF83F 0000E007 00000000
  00000000 E0030000 F81FF00F 183C381C 00380038 F03FE03B 3C3CF83F 1C381C38
  3C1C1C38 F00FF81F 0000E003 00000000 00000000 FC3F0000 FC1FFC3F 70003800
  E0007000 C001C001 80038003 80078003 00070007 00070007 00000006 00000000
  00000000 E0070000 F81FF00F 381C781E 781E381C F00FF00F 1C38381C 1C381C38
  3C3C1C38 F00FF81F 0000E007 00000000 00000000 C0070000 F81FF00F 1C38383C
  1C381C38 FC1F3C3C DC07FC0F 1C001C00 381C3C18 F00FF81F 0000C007 00000000
  00000000 00000000 00000000 80030000 80038003 00000000 00000000 00000000
  80038003 00008003 00000000 00000000 00000000 00000000 00000000 00000000
  80030000 80038003 00000000 00000000 00000000 80030003 80018003 00038001
  00000002 00000000 00000000 38000800 F803F800 001FC00F 001F001C F803C00F
  3800F800 00000800 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 FC3FFC3F 0000FC3F FC3F0000 FC3FFC3F 00000000 00000000 00000000
  00000000 00000000 00100000 001F001C F003C01F 3800F800 F003F800 001FC01F
  0010001C 00000000 00000000 00000000 00000000 F00FC007 783CF01F 38383838
  70003830 E001F000 8003C003 00018003 80030000 80038003 00008003 00000000
  00000000 00000000 00000000 F80FE003 04101C1C F227B623 625C724C 62586258
  EC586458 7027F86F 0C180630 F003FC0F 00000000 00000000 C0038001 E007C003
  600EE007 700E700E 381C781C FC3F381C 1C38FC3F 0E700E70 00000E60 00000000
  00000000 00000000 F03FE03F 38387838 38383838 F03F3838 3838F03F 1C381C38
  1C381C38 F83F3C38 0000F03F 00000000 00000000 00000000 F00FE007 3C3C781E
  0C781C38 00700070 00700070 0C700C70 3C3C1C38 F00F781E 0000E007 00000000
  00000000 00000000 F03FC03F 7838F038 1C383838 1C381C38 1C381C38 1C381C38
  78383838 F03FF038 0000C03F 00000000 00000000 00000000 FC1FFC1F 001C001C
  001C001C F81F001C 001CF81F 001C001C 001C001C FC1F001C 0000FC1F 00000000
  00000000 00000000 FC0FFC0F 000E000E 000E000E F80F000E 000EF80F 000E000E
  000E000E 000E000E 0000000E 00000000 00000000 00000000 F80FE003 1C383C1C
  0C700E38 00700070 FE70FE70 0E700E70 0E380E38 FC0F3E1C 0000F003 00000000
  00000000 00000000 1C381C38 1C381C38 1C381C38 FC3F1C38 1C38FC3F 1C381C38
  1C381C38 1C381C38 00001C38 00000000 00000000 00000000 80038003 80038003
  80038003 80038003 80038003 80038003 80038003 80038003 00008003 00000000
  00000000 00000000 E000E000 E000E000 E000E000 E000E000 E000E000 E070E070
  E079E070 C03FC03F 0000000F 00000000 00000000 00000000 1C380C38 78383C38
  E039F038 C03FC03B F03EE03F 7838703C 3C383C38 0E381E38 00000E38 00000000
  00000000 00000000 001C001C 001C001C 001C001C 001C001C 001C001C 001C001C
  001C001C F81F001C 0000F81F 00000000 00000000 00000000 1FF81FF8 3FFC3FFC
  37EC3FFC 77EE77EE 67E677EE E7E7E7E7 C7E3E7E7 C7E3C7E3 000087E1 00000000
  00000000 00000000 1C3C1C18 1C3E1C3C 1C3F1C3E 9C3B1C3B DC399C39 FC38DC38
  7C387C38 3C383C38 00001C38 00000000 00000000 00000000 F00FE007 3C3CF81F
  1E781C38 0E700E70 0E700E70 1E780E70 3C3C1C38 F00FF81F 0000E007 00000000
  00000000 00000000 F83FF03F 1C383C38 1C381C38 38381C38 E03FF83F 00380038
  00380038 00380038 00000038 00000000 00000000 00000000 F00FE007 3C3CF81F
  0E781C38 0E700E70 0E700E70 9E790E70 7C3CFC38 FE0FF81F 0700EF07 00000000
  00000000 00000000 FC3FF83F 0E381E38 0E380E38 FC3F1E38 E038F03F 78387038
  3C383C38 0E381E38 00000E38 00000000 00000000 00000000 F01FE007 3838381C
  003C1838 E01F003F F801F80F 1C303C00 1C381C38 F81F383C 0000E007 00000000
  00000000 00000000 FC7FFC7F 80038003 80038003 80038003 80038003 80038003
  80038003 80038003 00008003 00000000 00000000 00000000 1C381C38 1C381C38
  1C381C38 1C381C38 1C381C38 1C381C38 383C1C38 F00FF81F 0000E007 00000000
  00000000 00000000 0E380638 1C1C0E38 1C1C1C1C 380E180E 300E380E 70077007
  E0036007 C003E003 0000C001 00000000 00000000 00000000 C3C383C1 C7E3C7E3
  C663C7E3 66666666 6E766E76 3C3C6C36 3C3C3C3C 381C3C3C 00001818 00000000
  00000000 00000000 1E380C30 3C1C1C3C F00F781E E007F007 E007C003 F81FF00F
  3C3C781E 1E781E78 00000E70 00000000 00000000 00000000 1C781830 383C3838
  F01E701C C007E00E 8003C007 80038003 80038003 80038003 00008003 00000000
  00000000 00000000 F83FF83F 78007800 F001F000 C003E001 80078007 001E000F
  003C001E FC7F0078 0000FC7F 00000000 00000000 E0010000 8001E001 80018001
  80018001 80018001 80018001 80018001 80018001 80018001 80018001 E001E001
  00000000 00000000 001E000C 000F000E 00070007 80038007 C0038003 C001C001
  E000E001 F000E000 00007000 00000000 00000000 800F0000 8001800F 80018001
  80018001 80018001 80018001 80018001 80018001 80018001 80018001 800F800F
  00000000 00000000 80078003 C0078007 E00CC00E 601CE01C 00007038 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 FFFF0000 00000000
  00000000 00000000 003E001C 00630063 003E0063 0000001C 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  C00F0000 7018E01F F0007010 701EF00F 70387038 F01FF038 0000380E 00000000
  00000000 00000000 001C001C 001C001C F01D001C 381EF81F 1C1C1C1E 1C1C1C1C
  1C1E1C1C F81F381E 0000E01D 00000000 00000000 00000000 00000000 00000000
  C0070000 701CF00F 1038383C 00380038 383C1038 F00F781C 0000C007 00000000
  00000000 00000000 38003800 38003800 B80F3800 781CF81F 38387838 38383838
  78383838 F81F781C 0000B807 00000000 00000000 00000000 00000000 00000000
  C0070000 701CE00F 38383838 F03FF83F 10380038 F00F381C 0000C007 00000000
  00000000 00000000 E007E003 00070007 C01F0007 0007C01F 00070007 00070007
  00070007 00070007 00000007 00000000 00000000 00000000 00000000 00000000
  B80F0000 781CF81F 38383838 38383838 38383838 F81F781C 3810B807 701C3838
  C007F01F 00000000 00380038 00380038 C03B0038 F03CE03F 70387038 70387038
  70387038 70387038 00007038 00000000 00000000 00000000 80038003 00008003
  80030000 80038003 80038003 80038003 80038003 80038003 00008003 00000000
  00000000 00000000 80038003 00008003 80030000 80038003 80038003 80038003
  80038003 80038003 80038003 80038003 001F801F 00000000 000E000E 000E000E
  180E000E 700E380E C00FE00E 700FE00F 380E700E 1C0E380E 00000C0E 00000000
  00000000 00000000 80038003 80038003 80038003 80038003 80038003 80038003
  80038003 80038003 00008003 00000000 00000000 00000000 00000000 00000000
  9EEF0000 E7F1FFFF C7E1C7E1 C7E1C7E1 C7E1C7E1 C7E1C7E1 0000C7E1 00000000
  00000000 00000000 00000000 00000000 E01D0000 781EF01F 381C381C 381C381C
  381C381C 381C381C 0000381C 00000000 00000000 00000000 00000000 00000000
  800F0000 E038C01F 70707070 70707070 70707070 C01FE038 0000800F 00000000
  00000000 00000000 00000000 00000000 C03B0000 703CF03F 3838383C 38383838
  383C3838 F03F703C 0038C03B 00380038 00380038 00000000 00000000 00000000
  B8070000 781CF81F 38387838 38383838 78383838 F81F781C 3800B807 38003800
  38003800 00000000 00000000 00000000 E00E0000 100FF00F 000E000E 000E000E
  000E000E 000E000E 0000000E 00000000 00000000 00000000 00000000 00000000
  C0070000 701CF00F 001F301C F003E00F 381C7800 F00F381E 0000E007 00000000
  00000000 00000000 80038003 80038003 E0078003 8003E00F 80038003 80038003
  80038003 F0038003 0000F001 00000000 00000000 00000000 00000000 00000000
  381C0000 381C381C 381C381C 381C381C 381C381C F80F781E 0000B807 00000000
  00000000 00000000 00000000 00000000 18180000 381C381C 700E300C 6006700E
  C003E007 C003C003 00008001 00000000 00000000 00000000 00000000 00000000
  83C10000 C7E3C7E3 E667C663 6C366E76 7C3E6C36 381C381C 0000381C 00000000
  00000000 00000000 00000000 00000000 38380000 F01E783C C007E00F E00FC007
  F01EE00E 3838783C 00003830 00000000 00000000 00000000 00000000 00000000
  18180000 381C381C 700E300C 6006700E E0076007 C003C003 8001C003 80038003
  001E001F 00000000 00000000 00000000 F83F0000 7800F83F E001F000 8007C003
  000E0007 F83F001E 0000F83F 00000000 00000000 F0007000 C001F001 C001C001
  C001C001 8003C001 80078007 C0018003 C001C001 C001C001 F001C001 7000F000
  00000000 80038003 80038003 80038003 80038003 80038003 80038003 80038003
  80038003 80038003 80038003 80038003 00000000 001E001C 0007001F 00070007
  00070007 80030007 C003C003 00078003 00070007 00070007 001F0007 001C001E
  00000000 00000000 081E0000 F83FF83F 0000F020 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000
End DefineFont
  
CFunction CFindFrequency 'custom long mult/divide, working- 544ms on test case 4433619 from 40MHz
  00000000
  27BDFFA8 AFBE0054 AFB70050 AFB6004C AFB50048 AFB40044 AFB30040 AFB2003C
  AFB10038 AFB00034 8CA50000 8CC20000 2406FFFF 2407FFFF AFA60010 10A000EE
  AFA70014 104000E8 00403021 3C0304C4 3463B400 0062001A 004001F4 00001012
  24420001 3C0311E1 3463A300 0066001A 00C001F4 00003812 AFA70024 24030001
  0042180B AFA30020 00A0B821 2402FFFF AFA2001C 00061FC3 AFA30028 000567C3
  00A07021 AFAC0008 AFA5002C 00C0F021 100000B1 AFA4000C 00EA3021 00064FC3
  01860018 712B0000 00004812 00CB0019 00002810 01252821 0065482A 15200007
  00002012 54B00005 00C05021 0044202B 54800003 2508FFFF 00C05021 2508FFFF
  1500FFED 00073843 8FA20018 00580018 71F60000 00002012 03160019 00001012
  00001810 00831821 0140A821 000AA7C3 8FA40008 008A0018 728E0000 00003012
  014E0019 00002012 00002810 00C52821 2410001D 3C091000 00009821 00A09021
  01408821 01334021 000857C3 00680018 71420000 00005012 01020019 00003810
  01473821 00A7502A 15400007 00003012 54F20005 01009821 0086302B 54C00003
  2610FFFF 01009821 2610FFFF 1600FFED 00094843 027E2023 00042FC3 00A42026
  00852023 0097282A 10A00016 02205021 022D282A 54A00014 25540001 2A251000
  50A00011 25540001 8FA5000C ACB50000 ACB40004 ACB80008 ACAF000C ACB60010
  8FA60018 14800005 ACA60014 AFB30010 00139FC3 10000078 AFB30014 AFB3001C
  0080B821 25540001 0014AFC3 8FA40008 00940018 72AE0000 00003012 028E0019
  00002012 00002810 00C52821 2410001D 3C091000 00009821 00A09021 01408821
  01334021 000857C3 01420018 71030000 00005012 00480019 00003810 01473821
  00A7502A 15400007 00003012 54F20005 01009821 0086302B 54C00003 2610FFFF
  01009821 2610FFFF 1600FFED 00094843 027E1023 00021FC3 00621026 00431023
  0057182A 50600017 2739FFFF 022D182A 54600014 2739FFFF 2A2A1000 51400011
  2739FFFF 8FA3000C AC740000 AC750004 AC780008 AC6F000C AC760010 8FA40018
  14400005 AC640014 AFB30010 00139FC3 10000039 AFB30014 AFB3001C 0040B821
  2739FFFF 13200011 25AD0001 01A0C021 000D7FC3 8FA60004 00CD0018 8FA70000
  71E70000 00002012 01A70019 00001012 00001810 00831821 2408000C 24070800
  00005021 1000FF54 00608021 8FA60020 24C60001 AFA60020 8FA70020 8FA30024
  0067102A 14400013 00E0B021 000727C3 AFA40018 8FA30028 70671002 709E1802
  00621021 00FE0019 00002012 00002810 AFA40000 AFA50004 8FA50004 00452821
  AFA50004 241901FF 240D0001 1000FFD7 8FAB002C 8FA6001C AFA60010 00063FC3
  10000005 AFA70014 2402FFFF 2403FFFF AFA20010 AFA30014 8FA20010 8FA30014
  8FBE0054 8FB70050 8FB6004C 8FB50048 8FB40044 8FB30040 8FB2003C 8FB10038
  8FB00034 03E00008 27BD0058
End CFunction
  
CFunction I2CPort( INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,INTEGER ) INTEGER
  00000125 40024800 00442021 40024800 0044102B 1440FFFD 00000000 03E00008
  00000000 27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 00808821
  00A09821 00C09021 3C109D00 8E02001C 0040F809 2405FFFE 8E02001C 02602021
  0040F809 2405FFFE 02402021 0411FFE5 00000000 8E02001C 02202021 0040F809
  2405FFFD 02402021 0411FFDE 00000000 8E02001C 02602021 0040F809 2405FFFD
  02402021 0411FFD7 00000000 8FBF0024 8FB30020 8FB2001C 8FB10018 8FB00014
  03E00008 27BD0028 27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014
  00808821 00A09021 00C09821 3C109D00 8E02001C 00A02021 0040F809 2405FFFD
  8E02001C 02202021 0040F809 2405FFFD 02602021 0411FFBB 00000000 8E02001C
  02402021 0040F809 2405FFFE 02602021 0411FFB4 00000000 8E02001C 02202021
  0040F809 2405FFFE 02602021 0411FFAD 00000000 8FBF0024 8FB30020 8FB2001C
  8FB10018 8FB00014 03E00008 27BD0028 27BDFFD8 AFBF0024 AFB30020 AFB2001C
  AFB10018 AFB00014 00A08821 00C09821 8FA20038 10400007 00E09021 3C029D00
  8C42001C 0040F809 2405FFFE 10000006 2664FFF4 3C029D00 8C42001C 0040F809
  2405FFFD 2664FFF4 0411FF8E 00000000 3C029D00 8C42001C 02202021 0040F809
  2405FFFE 00001021 40824800 10000005 3C109D00 40024800 0052102A 1040000E
  8FBF0024 8E020020 0040F809 02202021 1040FFF8 02602021 0411FF7A 00000000
  3C029D00 8C42001C 02202021 0040F809 2405FFFD 8FBF0024 8FB30020 8FB2001C
  8FB10018 8FB00014 03E00008 27BD0028 27BDFFD8 AFBF0024 AFB40020 AFB3001C
  AFB20018 AFB10014 AFB00010 0080A021 00A08821 00C09821 00E09021 3C109D00
  8E02001C 0040F809 2405FFFE 0411FF5D 2664FFF2 8E02001C 02202021 0040F809
  2405FFFE 0411FF57 2664FFF8 00001021 40824800 10000006 8E020020 40024800
  0052102A 50400011 00008021 8E020020 0040F809 02202021 1040FFF8 00000000
  3C129D00 8E420020 0040F809 02802021 00408021 8E42001C 02202021 0040F809
  2405FFFD 10000002 02001021 02001021 8FBF0024 8FB40020 8FB3001C 8FB20018
  8FB10014 8FB00010 03E00008 27BD0028 27BDFFC8 AFBF0034 AFB60030 AFB5002C
  AFB40028 AFB30024 AFB20020 AFB1001C AFB00018 00809021 00A09821 00C0A021
  00E0A821 8FB10048 00008021 24160008 32220080 AFA20010 02402021 02602821
  02803021 02A03821 0411FF79 00000000 26100001 1616FFF6 00118840 02402021
  02602821 02803021 02A03821 0411FFA8 00000000 2C420001 8FBF0034 8FB60030
  8FB5002C 8FB40028 8FB30024 8FB20020 8FB1001C 8FB00018 03E00008 27BD0038
  27BDFFC8 AFBF0034 AFB60030 AFB5002C AFB40028 AFB30024 AFB20020 AFB1001C
  AFB00018 00809021 00A09821 00C0A021 00E0A821 00008021 00008821 24160008
  00108040 02402021 02602821 02803021 02A03821 0411FF86 00000000 26310001
  1636FFF7 02028025 8FA20048 2C420001 AFA20010 02402021 02602821 02803021
  02A03821 0411FF42 00000000 02001021 8FBF0034 8FB60030 8FB5002C 8FB40028
  8FB30024 8FB20020 8FB1001C 8FB00018 03E00008 27BD0038 27BDFFB0 AFBF004C
  AFBE0048 AFB70044 AFB60040 AFB5003C AFB40038 AFB30034 AFB20030 AFB1002C
  AFB00028 0080A021 00A08021 00C08821 00E0B821 8FB20064 3C029D00 8C420000
  8C530000 8FA20060 8C550000 3C0201C9 3442C380 0262102B 00002021 14400097
  00002821 8E040000 3C029D00 8C420088 00041880 00621021 8C430000 24020002
  10620005 3C029D00 8C420010 24050002 0040F809 2406000E 8E240000 3C029D00
  8C420088 00041880 00621021 8C430000 24020002 10620005 3C029D00 8C420010
  24050002 0040F809 2406000E 3C02001E 34428480 0262001B 004001F4 00009812
  00131080 0053F021 27DEFFE7 001319C0 00621023 00539821 00131080 02629821
  00131080 02629821 00139900 2673FFE7 AFB30018 02A0B021 3C139D00 8E62001C
  8E040000 0040F809 24050005 8E62001C 8E240000 0040F809 24050005 8E820000
  24030001 1443002A 00002021 03C0A821 8E040000 8E250000 03C03021 0411FE89
  00000000 8FB40018 8E040000 8E250000 8EE20000 00021040 AFA20010 03C03021
  02803821 0411FF42 00000000 00002021 00002821 1440000C 2413FFFF 10000048
  00801021 8E250000 8E420000 AFA20010 02A03021 02803821 0411FF35 00000000
  1040003C 26520008 26D6FFFF 16D3FFF5 8E040000 8E250000 03C03021 0411FE92
  00000000 24040001 10000034 00002821 24030002 14430031 00002821 AFBE001C
  8E040000 8E250000 03C03021 0411FE5D 00000000 8FA20018 AFA20020 8E040000
  8E250000 8EE20000 00021040 34420001 AFA20010 03C03021 8FA70018 0411FF14
  00000000 00002021 1040001C 00002821 12A00010 26B3FFFF 2414FFFF 8E040000
  8E250000 0013102B AFA20010 8FA6001C 8FA70020 0411FF32 00000000 AE420000
  000217C3 AE420004 2673FFFF 1674FFF3 26520008 8E040000 8E250000 03C03021
  0411FE61 00000000 24040001 10000003 00002821 00002021 00002821 00801021
  00A01821 8FBF004C 8FBE0048 8FB70044 8FB60040 8FB5003C 8FB40038 8FB30034
  8FB20030 8FB1002C 8FB00028 03E00008 27BD0050
End CFunction
  
CFunction PulseCounter  'as above, but no T5. 0=init,2=read accumulator, toggles RB11 every 20M cycles
  00000029
  'T1Int
  3C029D00 8C43008C 8C640010 24840001 AC640010 8C42008C 8C430010 28630140
  54600006 3C029D00 AC400010 24030800 3C02BF88 AC43613C 3C029D00 8C43008C
  8C650000 3404F424 00A42021 AC640000 8C42008C 8C430000 54600005 3C02BF88
  8C430004 24630001 AC430004 3C02BF88 8C431030 7C032104 AC431030 03E00008
  00000000
  'getFPC
  27BDFFF8 AFBF0004 00852023 03E42021 ACC40000 8FBF0004 03E00008 27BD0008
  'main
  27BDFFE0 AFBF001C 8C820000 8C830004 00432025 54800038 24040001 3C059D00
  24A500D4 27A60010 0411FFED 00000000 8FA50010 3C029D00 8C4300AC 3C049D00
  24840000 00852021 AC640000 8C43008C AC600000 8C43008C AC600004 8C42008C
  AC400010 3C02BF80 8C430600 7C037BC4 AC430600 8C430600 7C032904 AC430600
  8C440600 24030001 7C640844 AC440600 8C440600 7C041084 AC440600 3405F423
  3C04BF80 AC850620 3C04BF80 AC800610 3C04BF88 8C851030 7C052104 AC851030
  3C04BF88 8C851060 7C652104 AC851060 3C04BF88 8C8510A0 7C652084 AC8510A0
  8C440600 7C647BC4 AC440600 00002021 1000002E 00002821 14440003 24040002
  50600027 00002021 14440027 00002021 14600026 00002821 3C05BF88 24030010
  ACA31064 3C04BF88 AC801068 3C06BF88 8CC21030 7C4A0100 3C029D00 8C42008C
  3C07BF80 8CE90610 8C480004 8C420000 01224825 01201021 01003821 8CC61030
  7CC60100 ACA31064 AC831068 10C0000A 00402021 5540000D 00E02821 3C07FFFF
  01274824 3C020001 01221021 0049482B 01283821 00402021 10000004 00E02821
  10000002 00002821 00002821 00801021 00A01821 8FBF001C 03E00008 27BD0020
End CFunction
  
FUNCTION INITIC2()
  INITIC2=0
  LOCAL TEMP%
  TEMP%=0
  TEMP% = IC2WRITE()      'write our desired settings, don't worry about checking, because verify will fail
  TEMP%=0
  TEMP% = IC2READ()       'read back
  IF (IC2VERIFY()<>0) and (TEMP% <> 0) THEN INITIC2=1      'PLL present and responding
END FUNCTION
  
SUB COPYIC2
  LOCAL I%
  For I% = 1 to 25
    IC2CONFIGREAD%(I%)=IC2CONFIGWRITE%(I%)
  NEXT I%
END SUB
  
FUNCTION IC2READ() AS INTEGER     'reads into IC2CONFIGREAD%
  LOCAL I%,R%,D%(2),FLAG%
  FLAG%=1'cleared on any fault eg read error
  IC2READ=0
  For I% = 1 to 25
    R%=I2CPort(1, PIN.I2CSDA, PIN.I2CSCL, 105, 1, 128+I%) 'set read address
    'SETPIN PIN.I2CSCL,DIN                 'seems to be set to output low on idle
    'PRINT I%;":";R%;",";
    IF R%=0 THEN FLAG%=0                  'check
    R%=I2CPort(2, PIN.I2CSDA, PIN.I2CSCL, 105, 1, D%())   'read data
    'SETPIN PIN.I2CSCL,DIN                 'seems to be set to output low on idle
    'PRINT R%
    IF R%=0 THEN FLAG%=0                  'check
    IC2CONFIGREAD%(I%)=D%(0)             'save data
    'print I%;":";IC2CONFIGREAD%(I%)
  NEXT I%
  IC2READ=FLAG%
END FUNCTION
  
FUNCTION IC2WRITE() AS INTEGER     'writes from IC2CONFIGWRITE%
  LOCAL I%,R%,D%(2),FLAG%
  FLAG%=1'cleared on any fault eg read error
  IC2WRITE=0
  FOR I%= 1 to 25
    D%(0)=I%+128    'write single byte command
    D%(1)=IC2CONFIGWRITE%(I%) 'data to write
    R%=I2CPort(1, PIN.I2CSDA, PIN.I2CSCL, 105, 2, D%())   'write out
    'SETPIN PIN.I2CSCL,DIN                 'seems to be set to output low on idle
    'PRINT I%;":";R%
    IF R%=0 THEN FLAG%=0                  'check
  NEXT I%
  IC2WRITE=FLAG%
END FUNCTION
  
FUNCTION IC2VERIFY() AS INTEGER     'compares IC2CONFIGWRITE% to IC2CONFIGREAD%
  LOCAL I%
  IC2VERIFY=1 'set, clear on mismatch
  FOR I%= 1 to 25
    if IC2CONFIGWRITE%(I%) <> IC2CONFIGREAD%(I%) THEN IC2VERIFY=0
  NEXT I%
END FUNCTION
  
FUNCTION SETPLL(REGISTER% AS INTEGER,VALUE% as INTEGER) AS INTEGER
  SETPLL=1
  SELECT CASE REGISTER%
    CASe PLL1M,PLL2M,PLL3M      '9 bit registers with top bit in later byte
      IC2CONFIGWRITE%(REGISTER%)=VALUE% and 255
      IC2CONFIGWRITE%(REGISTER%+2)=(IC2CONFIGWRITE%(REGISTER%+2) AND 254) OR ((VALUE% AND 256)\256)
    CASE PLL1N,PLL2N,PLL3N      '12 bit registers with top 4 bits in next byte
      IC2CONFIGWRITE%(REGISTER%)=VALUE% and 255
      IC2CONFIGWRITE%(REGISTER%+1)=(IC2CONFIGWRITE%(REGISTER%+1) AND 225) OR ((VALUE% AND 3840)\128)
    CASE PLL1P,PLL2P,PLL3P,PLL4P      '7 bit registers
      IC2CONFIGWRITE%(REGISTER%)=VALUE% and 127
    CASE ELSE
      SETPLL=0        'not a valid register
      EXIT FUNCTION   'can't do anything
  END SELECT
  'SETPLL=IC2WRITE()   'return result of write
END FUNCTION
  
FUNCTION GETPLL(REGISTER% AS INTEGER) AS INTEGER
  GETPLL=-1               'fail
  'LOCAL TEMP%
  'TEMP% = IC2READ()
  'if TEMP% = 0 THEN EXIT FUNCTION   'no data returned
  SELECT CASE REGISTER%
    CASe PLL1M,PLL2M,PLL3M      '9 bit registers with top bit in later byte
      GETPLL=IC2CONFIGREAD%(REGISTER%)+256*(IC2CONFIGREAD%(REGISTER%+2) and 1)
    CASE PLL1N,PLL2N,PLL3N      '12 bit registers with top 4 bits in next byte
      GETPLL=IC2CONFIGREAD%(REGISTER%)+128*(IC2CONFIGREAD%(REGISTER%+1) and 30)
    CASE PLL1P,PLL2P,PLL3P,PLL4P      '7 bit registers
      GETPLL=IC2CONFIGREAD%(REGISTER%) AND 127
  END SELECT      'if we don't have a value yet, return -1
END FUNCTION
  
SUB PLLSET(N% As INTEGER)
  IF N%=0 THEN
    SETPIN PIN.PLLRUN,DOUT
    PIN(PIN.PLLRUN)=0
  ELSE
    SETPIN PIN.PLLRUN,DOUT
    PIN(PIN.PLLRUN)=1
  END IF
END SUB
  
SUB SET_CON_OUT(N% AS INTEGER)    'set output by connection (not PLL)
  LOCAL TEMP%,I%
  IF N%=3 THEN      'CON3=>PLL1
    TEMP%=SETPLL(PLL1N,FSET%(3,1))
    TEMP%=SETPLL(PLL1M,FSET%(3,2))
    TEMP%=SETPLL(PLL1P,FSET%(3,3))
    IF FSET%(3,0)*FSET%(3,3) < 190000000 THEN
      IC2CONFIGWRITE%(6)=IC2CONFIGWRITE%(6) AND 127   'clear FVCO bit, low VCO
    ELSE
      IC2CONFIGWRITE%(6)=IC2CONFIGWRITE%(6) OR 128   'set FVCO bit, high VCO
    END IF
  END IF
  IF N%=2 THEN      'CON2=>PLL2
    TEMP%=SETPLL(PLL2N,FSET%(2,1))
    TEMP%=SETPLL(PLL2M,FSET%(2,2))
    TEMP%=SETPLL(PLL2P,FSET%(2,3))
    IF FSET%(2,0)*FSET%(2,3) < 190000000 THEN
      IC2CONFIGWRITE%(6)=IC2CONFIGWRITE%(6) AND 191   'clear FVCO bit, low VCO
    ELSE
      IC2CONFIGWRITE%(6)=IC2CONFIGWRITE%(6) OR 64   'set FVCO bit, high VCO
    END IF
  END IF
  IF N%=4 THEN      'CON4=>PLL4 (with N,M fixed by PLL3)
    TEMP%=SETPLL(PLL4P,FSET%(4,3))
  END IF
  TEMP%=IC2WRITE()
  IF TEMP%=0 THEN TEMP%=IC2WRITE()  'retry on fail
END SUB
  
FUNCTION GPSFEED() AS INTEGER 'check serial data, add to sentence, parse if necessary
  GPSFEED  =0
  LOCAL T$
  LOCAL I%
  do WHILE LOC(#2) > 0
    IF Touch(x) <> -1 THEN EXIT FUNCTION      'jump out if key pressed to make buttons responsive
    IF LEN(GPSSENTENCE$)<150) THEN GPSSENTENCE$=GPSSENTENCE$+INPUT$(100,#2)
    IF LEFT$(GPSSENTENCE$,1)<> "$" THEN
      IF INSTR(1,GPSSENTENCE$,"$")=0 THEN
        GPSSENTENCE$=""
      ELSE
        GPSSENTENCE$=RIGHT$(GPSSENTENCE$,LEN(GPSSENTENCE$)-INSTR(1,GPSSENTENCE$,"$")+1)
      END IF
    END IF
    I%=INSTR(1,GPSSENTENCE$,"*")
    IF I% <> 0  and LEN(GPSSENTENCE$)>=I%+2 THEN 'complete sentence + checksum
      STATUS.GPS%=1                               'GPS data present
      IF LEFT$(GPSSENTENCE$,6)="$GPRMC" THEN
        GPSFEED=GPSPARSE()  'process
      ELSE
        GPSSENTENCE$=RIGHT$(GPSSENTENCE$,LEN(GPSSENTENCE$)-I%) 'dump sentence
      END IF
    END IF
    IF I%>80 THEN GPSSENTENCE$=""'    corrupted, purge
  LOOP
END FUNCTION
  
FUNCTION GPSPARSE() AS INTEGER      'success if a valid sentence was found (no checksum check)
  GPSPARSE=0
  LOCAL I%
  FOR I%=0 TO 19
    GPSFIELDS$(I%)=""
  NEXT I%
  I%=0
  DO WHILE INSTR(1,GPSSENTENCE$,",")<>0
    GPSFIELDS$(I%)=LEFT$(GPSSENTENCE$,INSTR(1,GPSSENTENCE$,",")-1)
    GPSSENTENCE$=RIGHT$(GPSSENTENCE$,LEN(GPSSENTENCE$)-INSTR(1,GPSSENTENCE$,","))
    I%=I%+1
    IF I%>19 THEN I%=19
  LOOP
  GPSTIME$=GPSFIELDS$(1)
  GPSLAT$=GPSFIELDS$(3)+GPSFIELDS$(4)
  GPSLON$=GPSFIELDS$(5)+GPSFIELDS$(6)
  GPSDATE$=GPSFIELDS$(9)
  GPSFIX$=GPSFIELDS$(2)
  IF GPSFIX$="A" THEN
    STATUS.GPSLOCKED%=1   'A not V means locked
  ELSE
    STATUS.GPSLOCKED%=0   'A not V means locked
  END IF
END FUNCTION
  
FUNCTION GETTEMP() AS FLOAT     'get temp from DS18B20 on PIN.IC7
  GETTEMP=TEMPR(PIN.IC7)      'returns 1000 on fail
END FUNCTION
  
FUNCTION STATSTRING(N%) AS STRING
  STATSTRING="Not ready"
  if N% <>0  THEN STATSTRING="OK       "  'pad for equal length
END FUNCTION
  
SUB SETDAC(DAC% AS INTEGER,VALUE% AS INTEGER)   'DAC%= DAC1A,DAC1B,DAC2A,DAC2B (DAC1=IC1, DAC2=IC8)
  SPI OPEN 10000000,0,16
  SetPin (DAC% AND 255), dout
  PIN (DAC% AND 255)=0    'CS low
  SPI WRITE 1, (DAC% AND &HF000) OR (VALUE% AND &H0FFF)
  PIN (DAC% AND 255)=1    'CS high
  SPI Close               'free for LCD
END SUB
  
SUB SETVCODAC(VALUE% AS INTEGER)   '24bit value => 0 to 16383
  SetPin PIN.IC1LDAC,DOUT                   'LDAC
  SETDAC(DAC1A,(VALUE%\4096) AND &H0FFF)    'top 12 bits
  SETDAC(DAC1B,VALUE% AND &H0FFF)           'bottom 12 bits
  PIN(PIN.IC1LDAC)=0
  PIN(PIN.IC1LDAC)=1
END SUB
  
SUB ISR1PPS     'triggered on 1PPS pin going high
  LOCAL COUNT%
  COUNT%=PulseCounter(2)                        'get current count
  ISR1PPSLASTPERIOD%=COUNT%-ISR1PPSLASTCOUNT%   'store difference
  ISR1PPSLASTCOUNT%=COUNT%                      'update count for next
  PPSCOUNT%=PPSCOUNT%+1
  ISR1PPSLASTTIMER%=TIMER
  IF ISR1PPSLASTPERIOD%>20000000 AND ISR1PPSLASTPERIOD%<60000000 THEN
    PLLACCUMULATOR%=PLLACCUMULATOR%+ISR1PPSLASTPERIOD%
    PLLCOUNT%=PLLCOUNT%+1
  END IF
END SUB
  
FUNCTION CHECKPPS()   'check for edges about 1s apart
  CHECKPPS=0
  IF PPSCOUNT% > 1 THEN CHECKPPS=1
END FUNCTION
  
FUNCTION CHECK40MHZ()   'check for appropriate number of counts/second
  CHECK40MHZ=0
  LOCAL R%
  LOCAL THISSTATE%,THISTIME%
  THISSTATE%=PulseCounter(2)
  THISTIME%=TIMER
  IF THISTIME%-CHECK40MHZLASTTIME%>200 THEN    'a second of counting
    R%=(THISSTATE%-CHECK40MHZLASTSTATE%)/(THISTIME%-CHECK40MHZLASTTIME%)
    IF (R% > 36000) AND (R% < 44000) THEN CHECK40MHZ=R%   'pulses in 1ms
    CHECK40MHZLASTTIME%=THISTIME%
    CHECK40MHZLASTSTATE%=THISSTATE%
  END IF
END FUNCTION
  
FUNCTION FUNCSTRING(N%) AS STRING    '1=PLL only, 2=disciplined, 3=temp comped
  FUNCSTRING="Not ready "
  if N% = 1 THEN FUNCSTRING="PLL Only  "
  if N% = 2 THEN FUNCSTRING="GPS Discip"
  if N% = 3 THEN FUNCSTRING="Temp Comp "
END FUNCTION
  
SUB DO_INIT_SCREEN
  CLS C.BACKGROUND
  TEXT 160,32,"Silicon Chip",CM,2,1,C.TEXT,C.BACKGROUND
  TEXT 160,56,"GPS Frequency",CM,2,1,C.TEXT,C.BACKGROUND
  TEXT 160,80,"Reference",CM,2,1,C.TEXT,C.BACKGROUND
  TEXT 160,104,"Starting...",CM,2,1,C.TEXT,C.BACKGROUND
  DO_STATS(70,120)
END SUB
  
SUB DO_STATS(X%,Y%)     'relocatable for startup/status page
  TEXT X%,Y%,"Temp Sensor:  "+STATSTRING(STATUS.TEMP%),LT,1,1,C.TEXT,C.BACKGROUND
  TEXT X%,Y%+16,"GPS 1PPS:     "+STATSTRING(STATUS.GPS1PPS%),LT,1,1,C.TEXT,C.BACKGROUND
  TEXT X%,Y%+32,"GPS Receiver: "+STATSTRING(STATUS.GPS%),LT,1,1,C.TEXT,C.BACKGROUND
  TEXT X%,Y%+48,"GPS Locked:   "+STATSTRING(STATUS.GPSLOCKED%),LT,1,1,C.TEXT,C.BACKGROUND
  TEXT X%,Y%+64,"PLL unit:     "+STATSTRING(STATUS.IC2%),LT,1,1,C.TEXT,C.BACKGROUND
  TEXT X%,Y%+80,"VCO output:   "+STATSTRING(STATUS.40MHZIN%),LT,1,1,C.TEXT,C.BACKGROUND
END SUB
  
SUB DO_INIT_PROCESS
  TIMER=0                     'clear timer
  LOCAL TEMP%
  SETVCODAC(VCOCONTROL%)      'VCO pulling voltage
  PLLSET(1)                   'turn on PLL
  SETDAC(DAC2A,4095)          'LED on
  SETDAC(DAC2B,0)             'oven heater off
  SETPIN PIN.MM1PPS,DOUT      'turn on 1PPS, toggled by ISR
  OPEN "COM2: 9600,400" AS #2     'GPS on 9/10, large buffer
  TEMP%=PulseCounter(0)       'init 40Mhz input counter
  SETPIN PIN.GPS1PPS,INTH,ISR1PPS,PULLDOWN   'set up ISR- needs PulseCounter to be inited
  PAUSE 100     'startup delay
  DO WHILE ((TIMER<STARTTIME) AND (STATUS.OVERALL%<3))
    DOBACKGROUND
    DO_STATS(70,120)
    SETDAC(DAC2A,2400+abs((TIMER MOD 3000)-1500)) 'LED fade with timer
    PAUSE 50
  LOOP
  SETDAC(DAC2A,0) 'LED off
END SUB
  
